/*
 i-net software provides programming examples for illustration only, without warranty
 either expressed or implied, including, but not limited to, the implied warranties
 of merchantability and/or fitness for a particular purpose. This programming example
 assumes that you are familiar with the programming language being demonstrated and
 the tools used to create and debug procedures. i-net software support professionals
 can help explain the functionality of a particular procedure, but they will not modify
 these examples to provide added functionality or construct procedures to meet your
 specific needs.
  
  i-net software 1998-2013

*/

namespace Inet.Viewer.Data
{

    /// <summary>
    /// A SearchChunks describes the location of a single result hit of a performed search.
    /// </summary>
    public class SearchChunk
    {
        internal readonly int StartIndex;
        internal readonly int EndIndex;
        internal readonly int X;
        internal readonly int Y;
        internal readonly int Page;

        /// <summary>
        /// Creates a search chunk.
        /// </summary>
        /// <param name="startIndex">the start index</param>
        /// <param name="endIndex">the end index</param>
        /// <param name="x">the x coordinate</param>
        /// <param name="y">the y coordinate</param>
        /// <param name="page">the page of the report</param>
        public SearchChunk(int startIndex, int endIndex, int x, int y, int page)
        {
            this.StartIndex = startIndex;
            this.EndIndex = endIndex;
            this.X = x;
            this.Y = y;
            this.Page = page;
        }
    }
}